'use strict';
angular.module('genisis').service('type',
  function () {

    var _types = [{
      id: 2,
      name: 'Detail Data'
    }, {
      id: 1,
      name: 'Aggregate Data'
    }];

    /**
     * Return the name of the type given the id
     * @param int id the id number of the type
     * @return string type name for that id
     **/
    this.toName = function (id) {
      if (!id) {
        return 'None';
      }

      var type = this.find(id);
      return (type) ? type.name : 'None';
    };

    /**
     * Find a specific type in the list
     * @param int id the type id
     * @return Object|null
     **/
    this.find = function (id) {

      if (!id) {
        return null;
      }

      //make sure it's always an integer
      id = parseInt(id, 10);

      var typ = null;

      angular.forEach(_types, function (type) {
        if (type.id === id) {
          typ = type;
        }
      });

      return typ;
    };

    /**
     * Return the array of types
     * @return Object[] types array
     **/
    this.get = function () {
      return _types;
    };

  }
);